package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DeleteVirtualGatewayRequest(
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest = {
    import DeleteVirtualGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualGatewayRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualGatewayRequest.wrap(buildAwsValue())
}
object DeleteVirtualGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualGatewayRequest =
      zio.aws.appmesh.model.DeleteVirtualGatewayRequest(
        meshName,
        meshOwner.map(value => value),
        virtualGatewayName
      )
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def virtualGatewayName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest
  ) extends zio.aws.appmesh.model.DeleteVirtualGatewayRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest
  ): zio.aws.appmesh.model.DeleteVirtualGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
