package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class CreateVirtualRouterRequest(
    clientToken: Optional[String] = Optional.Absent,
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    spec: zio.aws.appmesh.model.VirtualRouterSpec,
    tags: Optional[Iterable[zio.aws.appmesh.model.TagRef]] = Optional.Absent,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest = {
    import CreateVirtualRouterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateVirtualRouterRequest.ReadOnly =
    zio.aws.appmesh.model.CreateVirtualRouterRequest.wrap(buildAwsValue())
}
object CreateVirtualRouterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateVirtualRouterRequest =
      zio.aws.appmesh.model.CreateVirtualRouterRequest(
        clientToken.map(value => value),
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        virtualRouterName
      )
    def clientToken: Optional[String]
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def spec: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly
    def tags: Optional[List[zio.aws.appmesh.model.TagRef.ReadOnly]]
    def virtualRouterName: ResourceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest
  ) extends zio.aws.appmesh.model.CreateVirtualRouterRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterSpec.wrap(impl.spec())
    override val tags: Optional[List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.TagRef.wrap(item)
          }.toList
        )
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest
  ): zio.aws.appmesh.model.CreateVirtualRouterRequest.ReadOnly = new Wrapper(
    impl
  )
}
