package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.{
  AwsCloudMapInstanceAttributeValue,
  AwsCloudMapInstanceAttributeKey
}
import scala.jdk.CollectionConverters.*
final case class AwsCloudMapInstanceAttribute(
    key: AwsCloudMapInstanceAttributeKey,
    value: AwsCloudMapInstanceAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttribute = {
    import AwsCloudMapInstanceAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttribute
      .builder()
      .key(AwsCloudMapInstanceAttributeKey.unwrap(key): java.lang.String)
      .value(AwsCloudMapInstanceAttributeValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.ReadOnly =
    zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.wrap(buildAwsValue())
}
object AwsCloudMapInstanceAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.AwsCloudMapInstanceAttribute =
      zio.aws.appmesh.model.AwsCloudMapInstanceAttribute(key, value)
    def key: AwsCloudMapInstanceAttributeKey
    def value: AwsCloudMapInstanceAttributeValue
    def getKey: ZIO[Any, Nothing, AwsCloudMapInstanceAttributeKey] =
      ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, AwsCloudMapInstanceAttributeValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttribute
  ) extends zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.ReadOnly {
    override val key: AwsCloudMapInstanceAttributeKey =
      zio.aws.appmesh.model.primitives
        .AwsCloudMapInstanceAttributeKey(impl.key())
    override val value: AwsCloudMapInstanceAttributeValue =
      zio.aws.appmesh.model.primitives
        .AwsCloudMapInstanceAttributeValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttribute
  ): zio.aws.appmesh.model.AwsCloudMapInstanceAttribute.ReadOnly = new Wrapper(
    impl
  )
}
