package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  Timestamp,
  Arn
}
import scala.jdk.CollectionConverters.*
final case class MeshRef(
    arn: Arn,
    createdAt: Timestamp,
    lastUpdatedAt: Timestamp,
    meshName: ResourceName,
    meshOwner: AccountId,
    resourceOwner: AccountId,
    version: Long
) {
  def buildAwsValue(): software.amazon.awssdk.services.appmesh.model.MeshRef = {
    import MeshRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.MeshRef
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .meshOwner(AccountId.unwrap(meshOwner): java.lang.String)
      .resourceOwner(AccountId.unwrap(resourceOwner): java.lang.String)
      .version(version: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.MeshRef.ReadOnly =
    zio.aws.appmesh.model.MeshRef.wrap(buildAwsValue())
}
object MeshRef {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.MeshRef] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.MeshRef =
      zio.aws.appmesh.model.MeshRef(
        arn,
        createdAt,
        lastUpdatedAt,
        meshName,
        meshOwner,
        resourceOwner,
        version
      )
    def arn: Arn
    def createdAt: Timestamp
    def lastUpdatedAt: Timestamp
    def meshName: ResourceName
    def meshOwner: AccountId
    def resourceOwner: AccountId
    def version: Long
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, Nothing, AccountId] = ZIO.succeed(meshOwner)
    def getResourceOwner: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(resourceOwner)
    def getVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.MeshRef
  ) extends zio.aws.appmesh.model.MeshRef.ReadOnly {
    override val arn: Arn = zio.aws.appmesh.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.createdAt())
    override val lastUpdatedAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.meshOwner())
    override val resourceOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.resourceOwner())
    override val version: Long = impl.version(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.MeshRef
  ): zio.aws.appmesh.model.MeshRef.ReadOnly = new Wrapper(impl)
}
