package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait EgressFilterType {
  def unwrap: software.amazon.awssdk.services.appmesh.model.EgressFilterType
}
object EgressFilterType {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.EgressFilterType
  ): zio.aws.appmesh.model.EgressFilterType = value match {
    case software.amazon.awssdk.services.appmesh.model.EgressFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.EgressFilterType.ALLOW_ALL =>
      val r = ALLOW_ALL
      r
    case software.amazon.awssdk.services.appmesh.model.EgressFilterType.DROP_ALL =>
      val r = DROP_ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.EgressFilterType {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.EgressFilterType =
      software.amazon.awssdk.services.appmesh.model.EgressFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW_ALL extends zio.aws.appmesh.model.EgressFilterType {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.EgressFilterType =
      software.amazon.awssdk.services.appmesh.model.EgressFilterType.ALLOW_ALL
  }
  case object DROP_ALL extends zio.aws.appmesh.model.EgressFilterType {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.EgressFilterType =
      software.amazon.awssdk.services.appmesh.model.EgressFilterType.DROP_ALL
  }
}
