package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateVirtualNodeResponse(
    virtualNode: zio.aws.appmesh.model.VirtualNodeData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse = {
    import CreateVirtualNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse
      .builder()
      .virtualNode(virtualNode.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly =
    zio.aws.appmesh.model.CreateVirtualNodeResponse.wrap(buildAwsValue())
}
object CreateVirtualNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateVirtualNodeResponse =
      zio.aws.appmesh.model.CreateVirtualNodeResponse(virtualNode.asEditable)
    def virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly
    def getVirtualNode
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeData.ReadOnly] =
      ZIO.succeed(virtualNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse
  ) extends zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly {
    override val virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeData.wrap(impl.virtualNode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse
  ): zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
