package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters.*
final case class VirtualRouterServiceProvider(virtualRouterName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider = {
    import VirtualRouterServiceProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider
      .builder()
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualRouterServiceProvider.ReadOnly =
    zio.aws.appmesh.model.VirtualRouterServiceProvider.wrap(buildAwsValue())
}
object VirtualRouterServiceProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualRouterServiceProvider =
      zio.aws.appmesh.model.VirtualRouterServiceProvider(virtualRouterName)
    def virtualRouterName: ResourceName
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider
  ) extends zio.aws.appmesh.model.VirtualRouterServiceProvider.ReadOnly {
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider
  ): zio.aws.appmesh.model.VirtualRouterServiceProvider.ReadOnly = new Wrapper(
    impl
  )
}
