package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeMeshResponse(mesh: zio.aws.appmesh.model.MeshData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse = {
    import DescribeMeshResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse
      .builder()
      .mesh(mesh.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly =
    zio.aws.appmesh.model.DescribeMeshResponse.wrap(buildAwsValue())
}
object DescribeMeshResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeMeshResponse =
      zio.aws.appmesh.model.DescribeMeshResponse(mesh.asEditable)
    def mesh: zio.aws.appmesh.model.MeshData.ReadOnly
    def getMesh: ZIO[Any, Nothing, zio.aws.appmesh.model.MeshData.ReadOnly] =
      ZIO.succeed(mesh)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse
  ) extends zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly {
    override val mesh: zio.aws.appmesh.model.MeshData.ReadOnly =
      zio.aws.appmesh.model.MeshData.wrap(impl.mesh())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse
  ): zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly = new Wrapper(impl)
}
