package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TlsValidationContextTrust(
    acm: Option[zio.aws.appmesh.model.TlsValidationContextAcmTrust] = None,
    file: Option[zio.aws.appmesh.model.TlsValidationContextFileTrust] = None,
    sds: Option[zio.aws.appmesh.model.TlsValidationContextSdsTrust] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust = {
    import TlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.TlsValidationContextTrust.wrap(buildAwsValue())
}
object TlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TlsValidationContextTrust =
      zio.aws.appmesh.model.TlsValidationContextTrust(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm: Option[zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly]
    def file
        : Option[zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly]
    def sds: Option[zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
  ) extends zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly {
    override val acm
        : Option[zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly] =
      scala
        .Option(impl.acm())
        .map(value =>
          zio.aws.appmesh.model.TlsValidationContextAcmTrust.wrap(value)
        )
    override val file
        : Option[zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly] =
      scala
        .Option(impl.file())
        .map(value =>
          zio.aws.appmesh.model.TlsValidationContextFileTrust.wrap(value)
        )
    override val sds
        : Option[zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly] =
      scala
        .Option(impl.sds())
        .map(value =>
          zio.aws.appmesh.model.TlsValidationContextSdsTrust.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
  ): zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly = new Wrapper(
    impl
  )
}
