package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeVirtualServiceResponse(
    virtualService: zio.aws.appmesh.model.VirtualServiceData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse = {
    import DescribeVirtualServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse
      .builder()
      .virtualService(virtualService.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly =
    zio.aws.appmesh.model.DescribeVirtualServiceResponse.wrap(buildAwsValue())
}
object DescribeVirtualServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeVirtualServiceResponse =
      zio.aws.appmesh.model
        .DescribeVirtualServiceResponse(virtualService.asEditable)
    def virtualService: zio.aws.appmesh.model.VirtualServiceData.ReadOnly
    def getVirtualService
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceData.ReadOnly] =
      ZIO.succeed(virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse
  ) extends zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly {
    override val virtualService
        : zio.aws.appmesh.model.VirtualServiceData.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceData.wrap(impl.virtualService())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse
  ): zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly =
    new Wrapper(impl)
}
