package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.VirtualGatewaySdsSecretName
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListenerTlsSdsCertificate(
    secretName: VirtualGatewaySdsSecretName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate = {
    import VirtualGatewayListenerTlsSdsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
      .builder()
      .secretName(
        VirtualGatewaySdsSecretName.unwrap(secretName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsSdsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate(secretName)
    def secretName: VirtualGatewaySdsSecretName
    def getSecretName: ZIO[Any, Nothing, VirtualGatewaySdsSecretName] =
      ZIO.succeed(secretName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly {
    override val secretName: VirtualGatewaySdsSecretName =
      zio.aws.appmesh.model.primitives
        .VirtualGatewaySdsSecretName(impl.secretName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly =
    new Wrapper(impl)
}
