package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait MeshStatusCode {
  def unwrap: software.amazon.awssdk.services.appmesh.model.MeshStatusCode
}
object MeshStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.MeshStatusCode
  ): zio.aws.appmesh.model.MeshStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.MeshStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.MeshStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.MeshStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.MeshStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.appmesh.model.MeshStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.MeshStatusCode =
      software.amazon.awssdk.services.appmesh.model.MeshStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.MeshStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.MeshStatusCode =
      software.amazon.awssdk.services.appmesh.model.MeshStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.MeshStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.MeshStatusCode =
      software.amazon.awssdk.services.appmesh.model.MeshStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.MeshStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.MeshStatusCode =
      software.amazon.awssdk.services.appmesh.model.MeshStatusCode.DELETED
  }
}
