package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{ServiceName, MethodName}
import scala.jdk.CollectionConverters.*
final case class GrpcRouteMatch(
    metadata: Option[Iterable[zio.aws.appmesh.model.GrpcRouteMetadata]] = None,
    methodName: Option[MethodName] = None,
    serviceName: Option[ServiceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcRouteMatch = {
    import GrpcRouteMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcRouteMatch
      .builder()
      .optionallyWith(
        metadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metadata)
      .optionallyWith(
        methodName.map(value => MethodName.unwrap(value): java.lang.String)
      )(_.methodName)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcRouteMatch.ReadOnly =
    zio.aws.appmesh.model.GrpcRouteMatch.wrap(buildAwsValue())
}
object GrpcRouteMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcRouteMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcRouteMatch =
      zio.aws.appmesh.model.GrpcRouteMatch(
        metadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        methodName.map(value => value),
        serviceName.map(value => value)
      )
    def metadata: Option[List[zio.aws.appmesh.model.GrpcRouteMetadata.ReadOnly]]
    def methodName: Option[MethodName]
    def serviceName: Option[ServiceName]
    def getMetadata: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.GrpcRouteMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("metadata", metadata)
    def getMethodName: ZIO[Any, AwsError, MethodName] =
      AwsError.unwrapOptionField("methodName", methodName)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRouteMatch
  ) extends zio.aws.appmesh.model.GrpcRouteMatch.ReadOnly {
    override val metadata
        : Option[List[zio.aws.appmesh.model.GrpcRouteMetadata.ReadOnly]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.GrpcRouteMetadata.wrap(item)
        }.toList
      )
    override val methodName: Option[MethodName] = scala
      .Option(impl.methodName())
      .map(value => zio.aws.appmesh.model.primitives.MethodName(value))
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.appmesh.model.primitives.ServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRouteMatch
  ): zio.aws.appmesh.model.GrpcRouteMatch.ReadOnly = new Wrapper(impl)
}
