package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DeleteRouteRequest(
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    routeName: ResourceName,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest = {
    import DeleteRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .routeName(ResourceName.unwrap(routeName): java.lang.String)
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteRouteRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteRouteRequest.wrap(buildAwsValue())
}
object DeleteRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteRouteRequest =
      zio.aws.appmesh.model.DeleteRouteRequest(
        meshName,
        meshOwner.map(value => value),
        routeName,
        virtualRouterName
      )
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def routeName: ResourceName
    def virtualRouterName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getRouteName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(routeName)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest
  ) extends zio.aws.appmesh.model.DeleteRouteRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val routeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.routeName())
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest
  ): zio.aws.appmesh.model.DeleteRouteRequest.ReadOnly = new Wrapper(impl)
}
