package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListenerTls(
    certificate: zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate,
    mode: zio.aws.appmesh.model.VirtualGatewayListenerTlsMode,
    validation: Option[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTls = {
    import VirtualGatewayListenerTls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTls
      .builder()
      .certificate(certificate.buildAwsValue())
      .mode(mode.unwrap)
      .optionallyWith(validation.map(value => value.buildAwsValue()))(
        _.validation
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayListenerTls.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTls.wrap(buildAwsValue())
}
object VirtualGatewayListenerTls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayListenerTls =
      zio.aws.appmesh.model.VirtualGatewayListenerTls(
        certificate.asEditable,
        mode,
        validation.map(value => value.asEditable)
      )
    def certificate
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate.ReadOnly
    def mode: zio.aws.appmesh.model.VirtualGatewayListenerTlsMode
    def validation: Option[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext.ReadOnly
    ]
    def getCertificate: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate.ReadOnly
    ] = ZIO.succeed(certificate)
    def getMode: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsMode
    ] = ZIO.succeed(mode)
    def getValidation: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext.ReadOnly
    ] = AwsError.unwrapOptionField("validation", validation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTls
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTls.ReadOnly {
    override val certificate
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate
        .wrap(impl.certificate())
    override val mode: zio.aws.appmesh.model.VirtualGatewayListenerTlsMode =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsMode.wrap(impl.mode())
    override val validation: Option[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext.ReadOnly
    ] = scala
      .Option(impl.validation())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContext
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTls
  ): zio.aws.appmesh.model.VirtualGatewayListenerTls.ReadOnly = new Wrapper(
    impl
  )
}
