package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.HeaderMatch
import scala.jdk.CollectionConverters.*
final case class HeaderMatchMethod(
    exact: Option[HeaderMatch] = None,
    prefix: Option[HeaderMatch] = None,
    range: Option[zio.aws.appmesh.model.MatchRange] = None,
    regex: Option[HeaderMatch] = None,
    suffix: Option[HeaderMatch] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HeaderMatchMethod = {
    import HeaderMatchMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HeaderMatchMethod
      .builder()
      .optionallyWith(
        exact.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        prefix.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(range.map(value => value.buildAwsValue()))(_.range)
      .optionallyWith(
        regex.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.regex)
      .optionallyWith(
        suffix.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.suffix)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly =
    zio.aws.appmesh.model.HeaderMatchMethod.wrap(buildAwsValue())
}
object HeaderMatchMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HeaderMatchMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HeaderMatchMethod =
      zio.aws.appmesh.model.HeaderMatchMethod(
        exact.map(value => value),
        prefix.map(value => value),
        range.map(value => value.asEditable),
        regex.map(value => value),
        suffix.map(value => value)
      )
    def exact: Option[HeaderMatch]
    def prefix: Option[HeaderMatch]
    def range: Option[zio.aws.appmesh.model.MatchRange.ReadOnly]
    def regex: Option[HeaderMatch]
    def suffix: Option[HeaderMatch]
    def getExact: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("exact", exact)
    def getPrefix: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getRange
        : ZIO[Any, AwsError, zio.aws.appmesh.model.MatchRange.ReadOnly] =
      AwsError.unwrapOptionField("range", range)
    def getRegex: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("regex", regex)
    def getSuffix: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("suffix", suffix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HeaderMatchMethod
  ) extends zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly {
    override val exact: Option[HeaderMatch] = scala
      .Option(impl.exact())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
    override val prefix: Option[HeaderMatch] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
    override val range: Option[zio.aws.appmesh.model.MatchRange.ReadOnly] =
      scala
        .Option(impl.range())
        .map(value => zio.aws.appmesh.model.MatchRange.wrap(value))
    override val regex: Option[HeaderMatch] = scala
      .Option(impl.regex())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
    override val suffix: Option[HeaderMatch] = scala
      .Option(impl.suffix())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HeaderMatchMethod
  ): zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly = new Wrapper(impl)
}
