package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VirtualRouterStatus(
    status: zio.aws.appmesh.model.VirtualRouterStatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualRouterStatus = {
    import VirtualRouterStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualRouterStatus
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualRouterStatus.ReadOnly =
    zio.aws.appmesh.model.VirtualRouterStatus.wrap(buildAwsValue())
}
object VirtualRouterStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualRouterStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualRouterStatus =
      zio.aws.appmesh.model.VirtualRouterStatus(status)
    def status: zio.aws.appmesh.model.VirtualRouterStatusCode
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterStatusCode] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterStatus
  ) extends zio.aws.appmesh.model.VirtualRouterStatus.ReadOnly {
    override val status: zio.aws.appmesh.model.VirtualRouterStatusCode =
      zio.aws.appmesh.model.VirtualRouterStatusCode.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterStatus
  ): zio.aws.appmesh.model.VirtualRouterStatus.ReadOnly = new Wrapper(impl)
}
