package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListenerTlsValidationContextTrust(
    file: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
    ] = None,
    sds: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust = {
    import VirtualGatewayListenerTlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust(
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def file: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ]
    def sds: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly {
    override val file: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = scala
      .Option(impl.file())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
          .wrap(value)
      )
    override val sds: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = scala
      .Option(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsValidationContextTrust.ReadOnly =
    new Wrapper(impl)
}
