package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayBackendDefaults(
    clientPolicy: Option[zio.aws.appmesh.model.VirtualGatewayClientPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayBackendDefaults = {
    import VirtualGatewayBackendDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayBackendDefaults
      .builder()
      .optionallyWith(clientPolicy.map(value => value.buildAwsValue()))(
        _.clientPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayBackendDefaults.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayBackendDefaults.wrap(buildAwsValue())
}
object VirtualGatewayBackendDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayBackendDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayBackendDefaults =
      zio.aws.appmesh.model.VirtualGatewayBackendDefaults(
        clientPolicy.map(value => value.asEditable)
      )
    def clientPolicy
        : Option[zio.aws.appmesh.model.VirtualGatewayClientPolicy.ReadOnly]
    def getClientPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayClientPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("clientPolicy", clientPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayBackendDefaults
  ) extends zio.aws.appmesh.model.VirtualGatewayBackendDefaults.ReadOnly {
    override val clientPolicy
        : Option[zio.aws.appmesh.model.VirtualGatewayClientPolicy.ReadOnly] =
      scala
        .Option(impl.clientPolicy())
        .map(value =>
          zio.aws.appmesh.model.VirtualGatewayClientPolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayBackendDefaults
  ): zio.aws.appmesh.model.VirtualGatewayBackendDefaults.ReadOnly = new Wrapper(
    impl
  )
}
