package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class UpdateVirtualRouterRequest(
    clientToken: Option[String] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    spec: zio.aws.appmesh.model.VirtualRouterSpec,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest = {
    import UpdateVirtualRouterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualRouterRequest.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualRouterRequest.wrap(buildAwsValue())
}
object UpdateVirtualRouterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualRouterRequest =
      zio.aws.appmesh.model.UpdateVirtualRouterRequest(
        clientToken.map(value => value),
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        virtualRouterName
      )
    def clientToken: Option[String]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def spec: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly
    def virtualRouterName: ResourceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest
  ) extends zio.aws.appmesh.model.UpdateVirtualRouterRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterSpec.wrap(impl.spec())
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest
  ): zio.aws.appmesh.model.UpdateVirtualRouterRequest.ReadOnly = new Wrapper(
    impl
  )
}
