package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait RouteStatusCode {
  def unwrap: software.amazon.awssdk.services.appmesh.model.RouteStatusCode
}
object RouteStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.RouteStatusCode
  ): zio.aws.appmesh.model.RouteStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.RouteStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.RouteStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.RouteStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.RouteStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.RouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.RouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.RouteStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.RouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.RouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.RouteStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.RouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.RouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.RouteStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.RouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.RouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.RouteStatusCode.DELETED
  }
}
