package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Listener(
    connectionPool: Option[zio.aws.appmesh.model.VirtualNodeConnectionPool] =
      None,
    healthCheck: Option[zio.aws.appmesh.model.HealthCheckPolicy] = None,
    outlierDetection: Option[zio.aws.appmesh.model.OutlierDetection] = None,
    portMapping: zio.aws.appmesh.model.PortMapping,
    timeout: Option[zio.aws.appmesh.model.ListenerTimeout] = None,
    tls: Option[zio.aws.appmesh.model.ListenerTls] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.Listener
      .builder()
      .optionallyWith(connectionPool.map(value => value.buildAwsValue()))(
        _.connectionPool
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(outlierDetection.map(value => value.buildAwsValue()))(
        _.outlierDetection
      )
      .portMapping(portMapping.buildAwsValue())
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.Listener.ReadOnly =
    zio.aws.appmesh.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.Listener] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.Listener =
      zio.aws.appmesh.model.Listener(
        connectionPool.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        outlierDetection.map(value => value.asEditable),
        portMapping.asEditable,
        timeout.map(value => value.asEditable),
        tls.map(value => value.asEditable)
      )
    def connectionPool
        : Option[zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly]
    def healthCheck: Option[zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly]
    def outlierDetection
        : Option[zio.aws.appmesh.model.OutlierDetection.ReadOnly]
    def portMapping: zio.aws.appmesh.model.PortMapping.ReadOnly
    def timeout: Option[zio.aws.appmesh.model.ListenerTimeout.ReadOnly]
    def tls: Option[zio.aws.appmesh.model.ListenerTls.ReadOnly]
    def getConnectionPool: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("connectionPool", connectionPool)
    def getHealthCheck
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly] =
      AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getOutlierDetection
        : ZIO[Any, AwsError, zio.aws.appmesh.model.OutlierDetection.ReadOnly] =
      AwsError.unwrapOptionField("outlierDetection", outlierDetection)
    def getPortMapping
        : ZIO[Any, Nothing, zio.aws.appmesh.model.PortMapping.ReadOnly] =
      ZIO.succeed(portMapping)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ListenerTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTls: ZIO[Any, AwsError, zio.aws.appmesh.model.ListenerTls.ReadOnly] =
      AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.Listener
  ) extends zio.aws.appmesh.model.Listener.ReadOnly {
    override val connectionPool
        : Option[zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly] =
      scala
        .Option(impl.connectionPool())
        .map(value =>
          zio.aws.appmesh.model.VirtualNodeConnectionPool.wrap(value)
        )
    override val healthCheck
        : Option[zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly] = scala
      .Option(impl.healthCheck())
      .map(value => zio.aws.appmesh.model.HealthCheckPolicy.wrap(value))
    override val outlierDetection
        : Option[zio.aws.appmesh.model.OutlierDetection.ReadOnly] = scala
      .Option(impl.outlierDetection())
      .map(value => zio.aws.appmesh.model.OutlierDetection.wrap(value))
    override val portMapping: zio.aws.appmesh.model.PortMapping.ReadOnly =
      zio.aws.appmesh.model.PortMapping.wrap(impl.portMapping())
    override val timeout
        : Option[zio.aws.appmesh.model.ListenerTimeout.ReadOnly] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.appmesh.model.ListenerTimeout.wrap(value))
    override val tls: Option[zio.aws.appmesh.model.ListenerTls.ReadOnly] = scala
      .Option(impl.tls())
      .map(value => zio.aws.appmesh.model.ListenerTls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.Listener
  ): zio.aws.appmesh.model.Listener.ReadOnly = new Wrapper(impl)
}
