package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpRouteMatch(
    headers: Option[Iterable[zio.aws.appmesh.model.HttpRouteHeader]] = None,
    method: Option[zio.aws.appmesh.model.HttpMethod] = None,
    path: Option[zio.aws.appmesh.model.HttpPathMatch] = None,
    prefix: Option[String] = None,
    queryParameters: Option[
      Iterable[zio.aws.appmesh.model.HttpQueryParameter]
    ] = None,
    scheme: Option[zio.aws.appmesh.model.HttpScheme] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpRouteMatch = {
    import HttpRouteMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
      .builder()
      .optionallyWith(
        headers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headers)
      .optionallyWith(method.map(value => value.unwrap))(_.method)
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .optionallyWith(scheme.map(value => value.unwrap))(_.scheme)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpRouteMatch.ReadOnly =
    zio.aws.appmesh.model.HttpRouteMatch.wrap(buildAwsValue())
}
object HttpRouteMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpRouteMatch =
      zio.aws.appmesh.model.HttpRouteMatch(
        headers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        method.map(value => value),
        path.map(value => value.asEditable),
        prefix.map(value => value),
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheme.map(value => value)
      )
    def headers: Option[List[zio.aws.appmesh.model.HttpRouteHeader.ReadOnly]]
    def method: Option[zio.aws.appmesh.model.HttpMethod]
    def path: Option[zio.aws.appmesh.model.HttpPathMatch.ReadOnly]
    def prefix: Option[String]
    def queryParameters
        : Option[List[zio.aws.appmesh.model.HttpQueryParameter.ReadOnly]]
    def scheme: Option[zio.aws.appmesh.model.HttpScheme]
    def getHeaders: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.HttpRouteHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("headers", headers)
    def getMethod: ZIO[Any, AwsError, zio.aws.appmesh.model.HttpMethod] =
      AwsError.unwrapOptionField("method", method)
    def getPath
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpPathMatch.ReadOnly] =
      AwsError.unwrapOptionField("path", path)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.HttpQueryParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getScheme: ZIO[Any, AwsError, zio.aws.appmesh.model.HttpScheme] =
      AwsError.unwrapOptionField("scheme", scheme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
  ) extends zio.aws.appmesh.model.HttpRouteMatch.ReadOnly {
    override val headers
        : Option[List[zio.aws.appmesh.model.HttpRouteHeader.ReadOnly]] = scala
      .Option(impl.headers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.HttpRouteHeader.wrap(item)
        }.toList
      )
    override val method: Option[zio.aws.appmesh.model.HttpMethod] = scala
      .Option(impl.method())
      .map(value => zio.aws.appmesh.model.HttpMethod.wrap(value))
    override val path: Option[zio.aws.appmesh.model.HttpPathMatch.ReadOnly] =
      scala
        .Option(impl.path())
        .map(value => zio.aws.appmesh.model.HttpPathMatch.wrap(value))
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val queryParameters
        : Option[List[zio.aws.appmesh.model.HttpQueryParameter.ReadOnly]] =
      scala
        .Option(impl.queryParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.HttpQueryParameter.wrap(item)
          }.toList
        )
    override val scheme: Option[zio.aws.appmesh.model.HttpScheme] = scala
      .Option(impl.scheme())
      .map(value => zio.aws.appmesh.model.HttpScheme.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteMatch
  ): zio.aws.appmesh.model.HttpRouteMatch.ReadOnly = new Wrapper(impl)
}
