package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DeleteGatewayRouteRequest(
    gatewayRouteName: ResourceName,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest = {
    import DeleteGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest
      .builder()
      .gatewayRouteName(ResourceName.unwrap(gatewayRouteName): java.lang.String)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteGatewayRouteRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteGatewayRouteRequest.wrap(buildAwsValue())
}
object DeleteGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteGatewayRouteRequest =
      zio.aws.appmesh.model.DeleteGatewayRouteRequest(
        gatewayRouteName,
        meshName,
        meshOwner.map(value => value),
        virtualGatewayName
      )
    def gatewayRouteName: ResourceName
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def virtualGatewayName: ResourceName
    def getGatewayRouteName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(gatewayRouteName)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest
  ) extends zio.aws.appmesh.model.DeleteGatewayRouteRequest.ReadOnly {
    override val gatewayRouteName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.gatewayRouteName())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest
  ): zio.aws.appmesh.model.DeleteGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
