package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters.*
final case class CreateVirtualNodeRequest(
    clientToken: Option[String] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    spec: zio.aws.appmesh.model.VirtualNodeSpec,
    tags: Option[Iterable[zio.aws.appmesh.model.TagRef]] = None,
    virtualNodeName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest = {
    import CreateVirtualNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .virtualNodeName(ResourceName.unwrap(virtualNodeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateVirtualNodeRequest.ReadOnly =
    zio.aws.appmesh.model.CreateVirtualNodeRequest.wrap(buildAwsValue())
}
object CreateVirtualNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateVirtualNodeRequest =
      zio.aws.appmesh.model.CreateVirtualNodeRequest(
        clientToken.map(value => value),
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        virtualNodeName
      )
    def clientToken: Option[String]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def spec: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly
    def tags: Option[List[zio.aws.appmesh.model.TagRef.ReadOnly]]
    def virtualNodeName: ResourceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualNodeName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNodeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest
  ) extends zio.aws.appmesh.model.CreateVirtualNodeRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeSpec.wrap(impl.spec())
    override val tags: Option[List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.TagRef.wrap(item)
          }.toList
        )
    override val virtualNodeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNodeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest
  ): zio.aws.appmesh.model.CreateVirtualNodeRequest.ReadOnly = new Wrapper(impl)
}
