package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClientTlsCertificate(
    file: Option[zio.aws.appmesh.model.ListenerTlsFileCertificate] = None,
    sds: Option[zio.aws.appmesh.model.ListenerTlsSdsCertificate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate = {
    import ClientTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly =
    zio.aws.appmesh.model.ClientTlsCertificate.wrap(buildAwsValue())
}
object ClientTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ClientTlsCertificate =
      zio.aws.appmesh.model.ClientTlsCertificate(
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def file: Option[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly]
    def sds: Option[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
  ) extends zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly {
    override val file
        : Option[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly] =
      scala
        .Option(impl.file())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsFileCertificate.wrap(value)
        )
    override val sds
        : Option[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly] =
      scala
        .Option(impl.sds())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsSdsCertificate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate
  ): zio.aws.appmesh.model.ClientTlsCertificate.ReadOnly = new Wrapper(impl)
}
