package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccessLog(
    file: Option[zio.aws.appmesh.model.FileAccessLog] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.AccessLog = {
    import AccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.AccessLog
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.AccessLog.ReadOnly =
    zio.aws.appmesh.model.AccessLog.wrap(buildAwsValue())
}
object AccessLog {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.AccessLog] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.AccessLog =
      zio.aws.appmesh.model.AccessLog(file.map(value => value.asEditable))
    def file: Option[zio.aws.appmesh.model.FileAccessLog.ReadOnly]
    def getFile
        : ZIO[Any, AwsError, zio.aws.appmesh.model.FileAccessLog.ReadOnly] =
      AwsError.unwrapOptionField("file", file)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.AccessLog
  ) extends zio.aws.appmesh.model.AccessLog.ReadOnly {
    override val file: Option[zio.aws.appmesh.model.FileAccessLog.ReadOnly] =
      scala
        .Option(impl.file())
        .map(value => zio.aws.appmesh.model.FileAccessLog.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.AccessLog
  ): zio.aws.appmesh.model.AccessLog.ReadOnly = new Wrapper(impl)
}
