package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.ListMeshesLimit
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMeshesRequest(
    limit: Optional[ListMeshesLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListMeshesRequest = {
    import ListMeshesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListMeshesLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListMeshesRequest.ReadOnly =
    zio.aws.appmesh.model.ListMeshesRequest.wrap(buildAwsValue())
}
object ListMeshesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListMeshesRequest =
      zio.aws.appmesh.model.ListMeshesRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[ListMeshesLimit]
    def nextToken: Optional[String]
    def getLimit: ZIO[Any, AwsError, ListMeshesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
  ) extends zio.aws.appmesh.model.ListMeshesRequest.ReadOnly {
    override val limit: Optional[ListMeshesLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.appmesh.model.primitives.ListMeshesLimit(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
  ): zio.aws.appmesh.model.ListMeshesRequest.ReadOnly = new Wrapper(impl)
}
