package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VirtualGatewayConnectionPool(
    grpc: Optional[zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool] =
      Optional.Absent,
    http: Optional[zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool] =
      Optional.Absent,
    http2: Optional[zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool = {
    import VirtualGatewayConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
      .builder()
      .optionallyWith(grpc.map(value => value.buildAwsValue()))(_.grpc)
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(http2.map(value => value.buildAwsValue()))(_.http2)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayConnectionPool.wrap(buildAwsValue())
}
object VirtualGatewayConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayConnectionPool =
      zio.aws.appmesh.model.VirtualGatewayConnectionPool(
        grpc.map(value => value.asEditable),
        http.map(value => value.asEditable),
        http2.map(value => value.asEditable)
      )
    def grpc: Optional[
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly
    ]
    def http: Optional[
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly
    ]
    def http2: Optional[
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly
    ]
    def getGrpc: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("grpc", grpc)
    def getHttp: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("http", http)
    def getHttp2: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("http2", http2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
  ) extends zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly {
    override val grpc: Optional[
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.grpc())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.wrap(value)
      )
    override val http: Optional[
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.http())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.wrap(value)
      )
    override val http2: Optional[
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.http2())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
  ): zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly = new Wrapper(
    impl
  )
}
