package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.HeaderName
import scala.jdk.CollectionConverters._
final case class HttpRouteHeader(
    invert: Optional[Boolean] = Optional.Absent,
    `match`: Optional[zio.aws.appmesh.model.HeaderMatchMethod] =
      Optional.Absent,
    name: HeaderName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpRouteHeader = {
    import HttpRouteHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpRouteHeader
      .builder()
      .optionallyWith(invert.map(value => value: java.lang.Boolean))(_.invert)
      .optionallyWith(`match`.map(value => value.buildAwsValue()))(_.`match`)
      .name(HeaderName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpRouteHeader.ReadOnly =
    zio.aws.appmesh.model.HttpRouteHeader.wrap(buildAwsValue())
}
object HttpRouteHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpRouteHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpRouteHeader =
      zio.aws.appmesh.model.HttpRouteHeader(
        invert.map(value => value),
        `match`.map(value => value.asEditable),
        name
      )
    def invert: Optional[Boolean]
    def `match`: Optional[zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly]
    def name: HeaderName
    def getInvert: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("invert", invert)
    def getMatch
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly] =
      AwsError.unwrapOptionField("match", `match`)
    def getName: ZIO[Any, Nothing, HeaderName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteHeader
  ) extends zio.aws.appmesh.model.HttpRouteHeader.ReadOnly {
    override val invert: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.invert())
      .map(value => value: Boolean)
    override val `match`
        : Optional[zio.aws.appmesh.model.HeaderMatchMethod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`match`())
        .map(value => zio.aws.appmesh.model.HeaderMatchMethod.wrap(value))
    override val name: HeaderName =
      zio.aws.appmesh.model.primitives.HeaderName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRouteHeader
  ): zio.aws.appmesh.model.HttpRouteHeader.ReadOnly = new Wrapper(impl)
}
