package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GrpcGatewayRouteAction(
    rewrite: Optional[zio.aws.appmesh.model.GrpcGatewayRouteRewrite] =
      Optional.Absent,
    target: zio.aws.appmesh.model.GatewayRouteTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteAction = {
    import GrpcGatewayRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteAction
      .builder()
      .optionallyWith(rewrite.map(value => value.buildAwsValue()))(_.rewrite)
      .target(target.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcGatewayRouteAction.ReadOnly =
    zio.aws.appmesh.model.GrpcGatewayRouteAction.wrap(buildAwsValue())
}
object GrpcGatewayRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcGatewayRouteAction =
      zio.aws.appmesh.model.GrpcGatewayRouteAction(
        rewrite.map(value => value.asEditable),
        target.asEditable
      )
    def rewrite
        : Optional[zio.aws.appmesh.model.GrpcGatewayRouteRewrite.ReadOnly]
    def target: zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly
    def getRewrite: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.GrpcGatewayRouteRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("rewrite", rewrite)
    def getTarget
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly] =
      ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteAction
  ) extends zio.aws.appmesh.model.GrpcGatewayRouteAction.ReadOnly {
    override val rewrite
        : Optional[zio.aws.appmesh.model.GrpcGatewayRouteRewrite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rewrite())
        .map(value => zio.aws.appmesh.model.GrpcGatewayRouteRewrite.wrap(value))
    override val target: zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteTarget.wrap(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteAction
  ): zio.aws.appmesh.model.GrpcGatewayRouteAction.ReadOnly = new Wrapper(impl)
}
