package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.{ServiceName, ResourceName}
import scala.jdk.CollectionConverters._
final case class VirtualServiceData(
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    spec: zio.aws.appmesh.model.VirtualServiceSpec,
    status: zio.aws.appmesh.model.VirtualServiceStatus,
    virtualServiceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceData = {
    import VirtualServiceData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualServiceData
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .virtualServiceName(
        ServiceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualServiceData.ReadOnly =
    zio.aws.appmesh.model.VirtualServiceData.wrap(buildAwsValue())
}
object VirtualServiceData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualServiceData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualServiceData =
      zio.aws.appmesh.model.VirtualServiceData(
        meshName,
        metadata.asEditable,
        spec.asEditable,
        status.asEditable,
        virtualServiceName
      )
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def spec: zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly
    def status: zio.aws.appmesh.model.VirtualServiceStatus.ReadOnly
    def virtualServiceName: ServiceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualServiceStatus.ReadOnly
    ] = ZIO.succeed(status)
    def getVirtualServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceData
  ) extends zio.aws.appmesh.model.VirtualServiceData.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val spec: zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceSpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.VirtualServiceStatus.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceStatus.wrap(impl.status())
    override val virtualServiceName: ServiceName =
      zio.aws.appmesh.model.primitives.ServiceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceData
  ): zio.aws.appmesh.model.VirtualServiceData.ReadOnly = new Wrapper(impl)
}
