package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.ListenerPort
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GatewayRouteTarget(
    port: Optional[ListenerPort] = Optional.Absent,
    virtualService: zio.aws.appmesh.model.GatewayRouteVirtualService
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget = {
    import GatewayRouteTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
      .builder()
      .optionallyWith(port.map(value => ListenerPort.unwrap(value): Integer))(
        _.port
      )
      .virtualService(virtualService.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteTarget.wrap(buildAwsValue())
}
object GatewayRouteTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteTarget =
      zio.aws.appmesh.model
        .GatewayRouteTarget(port.map(value => value), virtualService.asEditable)
    def port: Optional[ListenerPort]
    def virtualService
        : zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly
    def getPort: ZIO[Any, AwsError, ListenerPort] =
      AwsError.unwrapOptionField("port", port)
    def getVirtualService: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly
    ] = ZIO.succeed(virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
  ) extends zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly {
    override val port: Optional[ListenerPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.ListenerPort(value))
    override val virtualService
        : zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteVirtualService
        .wrap(impl.virtualService())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
  ): zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly = new Wrapper(impl)
}
