package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{SuffixHostname, ExactHostName}
import scala.jdk.CollectionConverters._
final case class GatewayRouteHostnameMatch(
    exact: Optional[ExactHostName] = Optional.Absent,
    suffix: Optional[SuffixHostname] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch = {
    import GatewayRouteHostnameMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch
      .builder()
      .optionallyWith(
        exact.map(value => ExactHostName.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        suffix.map(value => SuffixHostname.unwrap(value): java.lang.String)
      )(_.suffix)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteHostnameMatch.wrap(buildAwsValue())
}
object GatewayRouteHostnameMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteHostnameMatch =
      zio.aws.appmesh.model.GatewayRouteHostnameMatch(
        exact.map(value => value),
        suffix.map(value => value)
      )
    def exact: Optional[ExactHostName]
    def suffix: Optional[SuffixHostname]
    def getExact: ZIO[Any, AwsError, ExactHostName] =
      AwsError.unwrapOptionField("exact", exact)
    def getSuffix: ZIO[Any, AwsError, SuffixHostname] =
      AwsError.unwrapOptionField("suffix", suffix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch
  ) extends zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly {
    override val exact: Optional[ExactHostName] = zio.aws.core.internal
      .optionalFromNullable(impl.exact())
      .map(value => zio.aws.appmesh.model.primitives.ExactHostName(value))
    override val suffix: Optional[SuffixHostname] = zio.aws.core.internal
      .optionalFromNullable(impl.suffix())
      .map(value => zio.aws.appmesh.model.primitives.SuffixHostname(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch
  ): zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly = new Wrapper(
    impl
  )
}
