package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class DescribeRouteRequest(
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    routeName: ResourceName,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest = {
    import DescribeRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .routeName(ResourceName.unwrap(routeName): java.lang.String)
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeRouteRequest.ReadOnly =
    zio.aws.appmesh.model.DescribeRouteRequest.wrap(buildAwsValue())
}
object DescribeRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeRouteRequest =
      zio.aws.appmesh.model.DescribeRouteRequest(
        meshName,
        meshOwner.map(value => value),
        routeName,
        virtualRouterName
      )
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def routeName: ResourceName
    def virtualRouterName: ResourceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getRouteName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(routeName)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest
  ) extends zio.aws.appmesh.model.DescribeRouteRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val routeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.routeName())
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest
  ): zio.aws.appmesh.model.DescribeRouteRequest.ReadOnly = new Wrapper(impl)
}
