package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{HttpPathRegex, HttpPathExact}
import scala.jdk.CollectionConverters._
final case class HttpPathMatch(
    exact: Optional[HttpPathExact] = Optional.Absent,
    regex: Optional[HttpPathRegex] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpPathMatch = {
    import HttpPathMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpPathMatch
      .builder()
      .optionallyWith(
        exact.map(value => HttpPathExact.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        regex.map(value => HttpPathRegex.unwrap(value): java.lang.String)
      )(_.regex)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpPathMatch.ReadOnly =
    zio.aws.appmesh.model.HttpPathMatch.wrap(buildAwsValue())
}
object HttpPathMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpPathMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpPathMatch = zio.aws.appmesh.model
      .HttpPathMatch(exact.map(value => value), regex.map(value => value))
    def exact: Optional[HttpPathExact]
    def regex: Optional[HttpPathRegex]
    def getExact: ZIO[Any, AwsError, HttpPathExact] =
      AwsError.unwrapOptionField("exact", exact)
    def getRegex: ZIO[Any, AwsError, HttpPathRegex] =
      AwsError.unwrapOptionField("regex", regex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpPathMatch
  ) extends zio.aws.appmesh.model.HttpPathMatch.ReadOnly {
    override val exact: Optional[HttpPathExact] = zio.aws.core.internal
      .optionalFromNullable(impl.exact())
      .map(value => zio.aws.appmesh.model.primitives.HttpPathExact(value))
    override val regex: Optional[HttpPathRegex] = zio.aws.core.internal
      .optionalFromNullable(impl.regex())
      .map(value => zio.aws.appmesh.model.primitives.HttpPathRegex(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpPathMatch
  ): zio.aws.appmesh.model.HttpPathMatch.ReadOnly = new Wrapper(impl)
}
