package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVirtualRouterResponse(
    virtualRouter: zio.aws.appmesh.model.VirtualRouterData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse = {
    import DeleteVirtualRouterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse
      .builder()
      .virtualRouter(virtualRouter.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualRouterResponse.wrap(buildAwsValue())
}
object DeleteVirtualRouterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualRouterResponse =
      zio.aws.appmesh.model
        .DeleteVirtualRouterResponse(virtualRouter.asEditable)
    def virtualRouter: zio.aws.appmesh.model.VirtualRouterData.ReadOnly
    def getVirtualRouter
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterData.ReadOnly] =
      ZIO.succeed(virtualRouter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse
  ) extends zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly {
    override val virtualRouter
        : zio.aws.appmesh.model.VirtualRouterData.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterData.wrap(impl.virtualRouter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse
  ): zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly = new Wrapper(
    impl
  )
}
