package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.TextFormat
import scala.jdk.CollectionConverters._
final case class LoggingFormat(
    json: Optional[Iterable[zio.aws.appmesh.model.JsonFormatRef]] =
      Optional.Absent,
    text: Optional[TextFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.LoggingFormat = {
    import LoggingFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.LoggingFormat
      .builder()
      .optionallyWith(
        json.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.json)
      .optionallyWith(
        text.map(value => TextFormat.unwrap(value): java.lang.String)
      )(_.text)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.LoggingFormat.ReadOnly =
    zio.aws.appmesh.model.LoggingFormat.wrap(buildAwsValue())
}
object LoggingFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.LoggingFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.LoggingFormat =
      zio.aws.appmesh.model.LoggingFormat(
        json.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        text.map(value => value)
      )
    def json: Optional[List[zio.aws.appmesh.model.JsonFormatRef.ReadOnly]]
    def text: Optional[TextFormat]
    def getJson: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.JsonFormatRef.ReadOnly
    ]] = AwsError.unwrapOptionField("json", json)
    def getText: ZIO[Any, AwsError, TextFormat] =
      AwsError.unwrapOptionField("text", text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.LoggingFormat
  ) extends zio.aws.appmesh.model.LoggingFormat.ReadOnly {
    override val json
        : Optional[List[zio.aws.appmesh.model.JsonFormatRef.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.json())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.JsonFormatRef.wrap(item)
          }.toList
        )
    override val text: Optional[TextFormat] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => zio.aws.appmesh.model.primitives.TextFormat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.LoggingFormat
  ): zio.aws.appmesh.model.LoggingFormat.ReadOnly = new Wrapper(impl)
}
