package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HttpGatewayRouteRewrite(
    hostname: Optional[zio.aws.appmesh.model.GatewayRouteHostnameRewrite] =
      Optional.Absent,
    path: Optional[zio.aws.appmesh.model.HttpGatewayRoutePathRewrite] =
      Optional.Absent,
    prefix: Optional[zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite = {
    import HttpGatewayRouteRewrite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
      .builder()
      .optionallyWith(hostname.map(value => value.buildAwsValue()))(_.hostname)
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .optionallyWith(prefix.map(value => value.buildAwsValue()))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRouteRewrite.wrap(buildAwsValue())
}
object HttpGatewayRouteRewrite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRouteRewrite =
      zio.aws.appmesh.model.HttpGatewayRouteRewrite(
        hostname.map(value => value.asEditable),
        path.map(value => value.asEditable),
        prefix.map(value => value.asEditable)
      )
    def hostname
        : Optional[zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly]
    def path
        : Optional[zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly]
    def prefix
        : Optional[zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly]
    def getHostname: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("hostname", hostname)
    def getPath: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("path", path)
    def getPrefix: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
  ) extends zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly {
    override val hostname
        : Optional[zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostname())
        .map(value =>
          zio.aws.appmesh.model.GatewayRouteHostnameRewrite.wrap(value)
        )
    override val path
        : Optional[zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.path())
        .map(value =>
          zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.wrap(value)
        )
    override val prefix: Optional[
      zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value =>
        zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
  ): zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly = new Wrapper(impl)
}
