package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait GatewayRouteStatusCode {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode
}
object GatewayRouteStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode
  ): zio.aws.appmesh.model.GatewayRouteStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.GatewayRouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.GatewayRouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.GatewayRouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.GatewayRouteStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode =
      software.amazon.awssdk.services.appmesh.model.GatewayRouteStatusCode.DELETED
  }
}
