package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters._
final case class TlsValidationContextFileTrust(certificateChain: FilePath) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TlsValidationContextFileTrust = {
    import TlsValidationContextFileTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextFileTrust
      .builder()
      .certificateChain(FilePath.unwrap(certificateChain): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly =
    zio.aws.appmesh.model.TlsValidationContextFileTrust.wrap(buildAwsValue())
}
object TlsValidationContextFileTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextFileTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TlsValidationContextFileTrust =
      zio.aws.appmesh.model.TlsValidationContextFileTrust(certificateChain)
    def certificateChain: FilePath
    def getCertificateChain: ZIO[Any, Nothing, FilePath] =
      ZIO.succeed(certificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextFileTrust
  ) extends zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly {
    override val certificateChain: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.certificateChain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextFileTrust
  ): zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly = new Wrapper(
    impl
  )
}
