package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RouteStatus(status: zio.aws.appmesh.model.RouteStatusCode) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.RouteStatus = {
    import RouteStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.RouteStatus
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.RouteStatus.ReadOnly =
    zio.aws.appmesh.model.RouteStatus.wrap(buildAwsValue())
}
object RouteStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.RouteStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.RouteStatus =
      zio.aws.appmesh.model.RouteStatus(status)
    def status: zio.aws.appmesh.model.RouteStatusCode
    def getStatus: ZIO[Any, Nothing, zio.aws.appmesh.model.RouteStatusCode] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.RouteStatus
  ) extends zio.aws.appmesh.model.RouteStatus.ReadOnly {
    override val status: zio.aws.appmesh.model.RouteStatusCode =
      zio.aws.appmesh.model.RouteStatusCode.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.RouteStatus
  ): zio.aws.appmesh.model.RouteStatus.ReadOnly = new Wrapper(impl)
}
