package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.ListenerPort
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TcpRouteMatch(port: Optional[ListenerPort] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TcpRouteMatch = {
    import TcpRouteMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TcpRouteMatch
      .builder()
      .optionallyWith(port.map(value => ListenerPort.unwrap(value): Integer))(
        _.port
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TcpRouteMatch.ReadOnly =
    zio.aws.appmesh.model.TcpRouteMatch.wrap(buildAwsValue())
}
object TcpRouteMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TcpRouteMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TcpRouteMatch =
      zio.aws.appmesh.model.TcpRouteMatch(port.map(value => value))
    def port: Optional[ListenerPort]
    def getPort: ZIO[Any, AwsError, ListenerPort] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TcpRouteMatch
  ) extends zio.aws.appmesh.model.TcpRouteMatch.ReadOnly {
    override val port: Optional[ListenerPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.ListenerPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TcpRouteMatch
  ): zio.aws.appmesh.model.TcpRouteMatch.ReadOnly = new Wrapper(impl)
}
