package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class MeshData(
    meshName: ResourceName,
    metadata: zio.aws.appmesh.model.ResourceMetadata,
    spec: zio.aws.appmesh.model.MeshSpec,
    status: zio.aws.appmesh.model.MeshStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.MeshData = {
    import MeshData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.MeshData
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .spec(spec.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.MeshData.ReadOnly =
    zio.aws.appmesh.model.MeshData.wrap(buildAwsValue())
}
object MeshData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.MeshData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.MeshData =
      zio.aws.appmesh.model.MeshData(
        meshName,
        metadata.asEditable,
        spec.asEditable,
        status.asEditable
      )
    def meshName: ResourceName
    def metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly
    def spec: zio.aws.appmesh.model.MeshSpec.ReadOnly
    def status: zio.aws.appmesh.model.MeshStatus.ReadOnly
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.appmesh.model.ResourceMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getSpec: ZIO[Any, Nothing, zio.aws.appmesh.model.MeshSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.MeshStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.MeshData
  ) extends zio.aws.appmesh.model.MeshData.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val metadata: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
      zio.aws.appmesh.model.ResourceMetadata.wrap(impl.metadata())
    override val spec: zio.aws.appmesh.model.MeshSpec.ReadOnly =
      zio.aws.appmesh.model.MeshSpec.wrap(impl.spec())
    override val status: zio.aws.appmesh.model.MeshStatus.ReadOnly =
      zio.aws.appmesh.model.MeshStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.MeshData
  ): zio.aws.appmesh.model.MeshData.ReadOnly = new Wrapper(impl)
}
