package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class UpdateMeshRequest(
    clientToken: Optional[String] = Optional.Absent,
    meshName: ResourceName,
    spec: Optional[zio.aws.appmesh.model.MeshSpec] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest = {
    import UpdateMeshRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(spec.map(value => value.buildAwsValue()))(_.spec)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateMeshRequest.ReadOnly =
    zio.aws.appmesh.model.UpdateMeshRequest.wrap(buildAwsValue())
}
object UpdateMeshRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateMeshRequest =
      zio.aws.appmesh.model.UpdateMeshRequest(
        clientToken.map(value => value),
        meshName,
        spec.map(value => value.asEditable)
      )
    def clientToken: Optional[String]
    def meshName: ResourceName
    def spec: Optional[zio.aws.appmesh.model.MeshSpec.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getSpec: ZIO[Any, AwsError, zio.aws.appmesh.model.MeshSpec.ReadOnly] =
      AwsError.unwrapOptionField("spec", spec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest
  ) extends zio.aws.appmesh.model.UpdateMeshRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val spec: Optional[zio.aws.appmesh.model.MeshSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spec())
        .map(value => zio.aws.appmesh.model.MeshSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest
  ): zio.aws.appmesh.model.UpdateMeshRequest.ReadOnly = new Wrapper(impl)
}
