package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{ServiceName, ListenerPort}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GrpcGatewayRouteMatch(
    hostname: Optional[zio.aws.appmesh.model.GatewayRouteHostnameMatch] =
      Optional.Absent,
    metadata: Optional[
      Iterable[zio.aws.appmesh.model.GrpcGatewayRouteMetadata]
    ] = Optional.Absent,
    port: Optional[ListenerPort] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMatch = {
    import GrpcGatewayRouteMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMatch
      .builder()
      .optionallyWith(hostname.map(value => value.buildAwsValue()))(_.hostname)
      .optionallyWith(
        metadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metadata)
      .optionallyWith(port.map(value => ListenerPort.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcGatewayRouteMatch.ReadOnly =
    zio.aws.appmesh.model.GrpcGatewayRouteMatch.wrap(buildAwsValue())
}
object GrpcGatewayRouteMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcGatewayRouteMatch =
      zio.aws.appmesh.model.GrpcGatewayRouteMatch(
        hostname.map(value => value.asEditable),
        metadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        port.map(value => value),
        serviceName.map(value => value)
      )
    def hostname
        : Optional[zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly]
    def metadata: Optional[
      List[zio.aws.appmesh.model.GrpcGatewayRouteMetadata.ReadOnly]
    ]
    def port: Optional[ListenerPort]
    def serviceName: Optional[ServiceName]
    def getHostname: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly
    ] = AwsError.unwrapOptionField("hostname", hostname)
    def getMetadata: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.GrpcGatewayRouteMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("metadata", metadata)
    def getPort: ZIO[Any, AwsError, ListenerPort] =
      AwsError.unwrapOptionField("port", port)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMatch
  ) extends zio.aws.appmesh.model.GrpcGatewayRouteMatch.ReadOnly {
    override val hostname
        : Optional[zio.aws.appmesh.model.GatewayRouteHostnameMatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostname())
        .map(value =>
          zio.aws.appmesh.model.GatewayRouteHostnameMatch.wrap(value)
        )
    override val metadata: Optional[
      List[zio.aws.appmesh.model.GrpcGatewayRouteMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.GrpcGatewayRouteMetadata.wrap(item)
        }.toList
      )
    override val port: Optional[ListenerPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.ListenerPort(value))
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.appmesh.model.primitives.ServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMatch
  ): zio.aws.appmesh.model.GrpcGatewayRouteMatch.ReadOnly = new Wrapper(impl)
}
