package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait VirtualGatewayPortProtocol {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol
}
object VirtualGatewayPortProtocol {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol
  ): zio.aws.appmesh.model.VirtualGatewayPortProtocol = value match {
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.HTTP =>
      val r = http
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.HTTP2 =>
      val r = http2
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.GRPC =>
      val r = grpc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.VirtualGatewayPortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object http extends zio.aws.appmesh.model.VirtualGatewayPortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.HTTP
  }
  case object http2 extends zio.aws.appmesh.model.VirtualGatewayPortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.HTTP2
  }
  case object grpc extends zio.aws.appmesh.model.VirtualGatewayPortProtocol {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol =
      software.amazon.awssdk.services.appmesh.model.VirtualGatewayPortProtocol.GRPC
  }
}
