package zio.aws.appmesh.model
import scala.jdk.CollectionConverters._
sealed trait IpPreference {
  def unwrap: software.amazon.awssdk.services.appmesh.model.IpPreference
}
object IpPreference {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.IpPreference
  ): zio.aws.appmesh.model.IpPreference = value match {
    case software.amazon.awssdk.services.appmesh.model.IpPreference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V6_PREFERRED =>
      val r = IPv6_PREFERRED
      r
    case software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V4_PREFERRED =>
      val r = IPv4_PREFERRED
      r
    case software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V4_ONLY =>
      val r = IPv4_ONLY
      r
    case software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V6_ONLY =>
      val r = IPv6_ONLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.appmesh.model.IpPreference {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.IpPreference =
      software.amazon.awssdk.services.appmesh.model.IpPreference.UNKNOWN_TO_SDK_VERSION
  }
  case object IPv6_PREFERRED extends zio.aws.appmesh.model.IpPreference {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.IpPreference =
      software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V6_PREFERRED
  }
  case object IPv4_PREFERRED extends zio.aws.appmesh.model.IpPreference {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.IpPreference =
      software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V4_PREFERRED
  }
  case object IPv4_ONLY extends zio.aws.appmesh.model.IpPreference {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.IpPreference =
      software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V4_ONLY
  }
  case object IPv6_ONLY extends zio.aws.appmesh.model.IpPreference {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.IpPreference =
      software.amazon.awssdk.services.appmesh.model.IpPreference.IP_V6_ONLY
  }
}
