package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters._
final case class FileAccessLog(
    format: Optional[zio.aws.appmesh.model.LoggingFormat] = Optional.Absent,
    path: FilePath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.FileAccessLog = {
    import FileAccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.FileAccessLog
      .builder()
      .optionallyWith(format.map(value => value.buildAwsValue()))(_.format)
      .path(FilePath.unwrap(path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.FileAccessLog.ReadOnly =
    zio.aws.appmesh.model.FileAccessLog.wrap(buildAwsValue())
}
object FileAccessLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.FileAccessLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.FileAccessLog = zio.aws.appmesh.model
      .FileAccessLog(format.map(value => value.asEditable), path)
    def format: Optional[zio.aws.appmesh.model.LoggingFormat.ReadOnly]
    def path: FilePath
    def getFormat
        : ZIO[Any, AwsError, zio.aws.appmesh.model.LoggingFormat.ReadOnly] =
      AwsError.unwrapOptionField("format", format)
    def getPath: ZIO[Any, Nothing, FilePath] = ZIO.succeed(path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.FileAccessLog
  ) extends zio.aws.appmesh.model.FileAccessLog.ReadOnly {
    override val format
        : Optional[zio.aws.appmesh.model.LoggingFormat.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.appmesh.model.LoggingFormat.wrap(value))
    override val path: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.FileAccessLog
  ): zio.aws.appmesh.model.FileAccessLog.ReadOnly = new Wrapper(impl)
}
