package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateVirtualNodeRequest(
    clientToken: Optional[String] = Optional.Absent,
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    spec: zio.aws.appmesh.model.VirtualNodeSpec,
    virtualNodeName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest = {
    import UpdateVirtualNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .virtualNodeName(ResourceName.unwrap(virtualNodeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualNodeRequest.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualNodeRequest.wrap(buildAwsValue())
}
object UpdateVirtualNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualNodeRequest =
      zio.aws.appmesh.model.UpdateVirtualNodeRequest(
        clientToken.map(value => value),
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        virtualNodeName
      )
    def clientToken: Optional[String]
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def spec: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly
    def virtualNodeName: ResourceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getVirtualNodeName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNodeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest
  ) extends zio.aws.appmesh.model.UpdateVirtualNodeRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeSpec.wrap(impl.spec())
    override val virtualNodeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNodeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest
  ): zio.aws.appmesh.model.UpdateVirtualNodeRequest.ReadOnly = new Wrapper(impl)
}
